<x-admin-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <div>
                <h2 class="font-light text-lg text-black leading-tight mr-4">
                    {{ __('Edit Payment Method') }}
                </h2>
            </div>
            <a href="{{ route('admin.payment_methods.index') }}" 
               class="inline-flex items-center px-3 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-200 transition-all duration-200">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back
            </a>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="max-w-8xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white border border-gray-200 dark:border-blue-600 overflow-hidden rounded-lg">
                <form action="{{ route('admin.payment_methods.update', $paymentMethod) }}" method="POST" enctype="multipart/form-data" class="space-y-4">
                    @csrf
                    @method('PUT')
                    
                    <div class="px-4 py-3 border-b border-gray-200 dark:border-blue-600">
                        <h3 class="text-base font-medium text-black">Payment Method Information</h3>
                        <p class="text-xs text-gray-600 mt-1">Update the details for this payment method</p>
                    </div>

                    <div class="px-4 py-4 space-y-4">
                        <!-- Basic Information -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="name" class="block text-xs font-medium text-gray-700 mb-2">Payment Method Name</label>
                                <input type="text" 
                                       name="name" 
                                       id="name"
                                       value="{{ old('name', $paymentMethod->name) }}"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-black @error('name') border-red-500 @enderror"
                                       placeholder="e.g., Bitcoin, Credit Card, PayPal"
                                       required>
                                @error('name')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="type" class="block text-xs font-medium text-gray-700 mb-2">Payment Type</label>
                                <select name="type" 
                                        id="type" 
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-black @error('type') border-red-500 @enderror"
                                        onchange="toggleCryptoFields()"
                                        required>
                                    <option value="traditional" {{ old('type', $paymentMethod->type) == 'traditional' ? 'selected' : '' }}>Traditional Payment</option>
                                    <option value="cryptocurrency" {{ old('type', $paymentMethod->type) == 'cryptocurrency' ? 'selected' : '' }}>Cryptocurrency</option>
                                </select>
                                @error('type')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Details -->
                        <div>
                            <label for="details" class="block text-xs font-medium text-gray-700 mb-2">Description</label>
                            <textarea name="details" 
                                      id="details" 
                                      rows="3"
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-black @error('details') border-red-500 @enderror"
                                      placeholder="Additional information about this payment method">{{ old('details', $paymentMethod->details) }}</textarea>
                            @error('details')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Current Logo Display -->
                        @if($paymentMethod->logo_url)
                        <div>
                            <label class="block text-xs font-medium text-gray-700 mb-2">Current Logo</label>
                            <div class="flex items-center space-x-4">
                                <img src="{{ $paymentMethod->logo_url }}" 
                                     alt="{{ $paymentMethod->name }}" 
                                     class="w-12 h-12 object-contain rounded border border-gray-200 dark:border-blue-600">
                                <div class="text-xs text-gray-600 dark:text-blue-100">
                                    <p>Current logo image</p>
                                    <p class="text-xs">Upload a new image to replace it</p>
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Logo Upload -->
                        <div>
                            <label for="logo" class="block text-xs font-medium text-gray-700 mb-2">
                                {{ $paymentMethod->logo_url ? 'Update Logo/Icon' : 'Logo/Icon' }}
                            </label>
                            <input type="file" 
                                   name="logo" 
                                   id="logo"
                                   accept="image/*"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-black @error('logo') border-red-500 @enderror">
                            <p class="mt-1 text-xs text-gray-500 dark:text-blue-200">Upload a logo or icon for this payment method (PNG, JPG, SVG)</p>
                            @error('logo')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Cryptocurrency Fields -->
                        <div id="crypto-fields" class="space-y-4 p-4 bg-blue-50 rounded-lg border border-blue-200" style="display: {{ $paymentMethod->isCryptocurrency() ? 'block' : 'none' }};">
                            <h4 class="text-base font-medium text-blue-900 mb-3">Cryptocurrency Settings</h4>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="crypto_symbol" class="block text-xs font-medium text-gray-700 mb-2">Crypto Symbol</label>
                                    <input type="text" 
                                           name="crypto_symbol" 
                                           id="crypto_symbol"
                                           value="{{ old('crypto_symbol', $paymentMethod->crypto_symbol) }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-black @error('crypto_symbol') border-red-500 @enderror"
                                           placeholder="e.g., BTC, ETH, LTC">
                                    @error('crypto_symbol')
                                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="network_fee" class="block text-xs font-medium text-gray-700 mb-2">Network Fee</label>
                                    <input type="number" 
                                           name="network_fee" 
                                           id="network_fee"
                                           value="{{ old('network_fee', $paymentMethod->network_fee) }}"
                                           step="0.00000001"
                                           min="0"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-black @error('network_fee') border-red-500 @enderror"
                                           placeholder="0.00001">
                                    <p class="mt-1 text-xs text-gray-500 dark:text-blue-200">Network transaction fee in crypto units</p>
                                    @error('network_fee')
                                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>

                            <div>
                                <label for="wallet_address" class="block text-xs font-medium text-gray-700 mb-2">Wallet Address</label>
                                <input type="text" 
                                       name="wallet_address" 
                                       id="wallet_address"
                                       value="{{ old('wallet_address', $paymentMethod->wallet_address) }}"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-black @error('wallet_address') border-red-500 @enderror font-mono text-sm"
                                       placeholder="Enter the wallet address for receiving payments">
                                @error('wallet_address')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Current QR Code Display -->
                            @if($paymentMethod->barcode_url)
                            <div>
                                <label class="block text-xs font-medium text-gray-700 mb-2">Current QR Code</label>
                                <div class="flex items-center space-x-4">
                                    <img src="{{ $paymentMethod->barcode_url }}" 
                                         alt="QR Code" 
                                         class="w-12 h-12 object-contain rounded border border-gray-200 dark:border-blue-600">
                                    <div class="text-xs text-gray-600 dark:text-blue-100">
                                        <p>Current QR code image</p>
                                        <p class="text-xs">Upload a new image to replace it</p>
                                    </div>
                                </div>
                            </div>
                            @endif

                            <div>
                                <label for="barcode" class="block text-xs font-medium text-gray-700 mb-2">
                                    {{ $paymentMethod->barcode_url ? 'Update QR Code/Barcode' : 'QR Code/Barcode' }}
                                </label>
                                <input type="file" 
                                       name="barcode" 
                                       id="barcode"
                                       accept="image/*"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-black @error('barcode') border-red-500 @enderror">
                                <p class="mt-1 text-xs text-gray-500 dark:text-blue-200">Upload a QR code image for the wallet address</p>
                                @error('barcode')
                                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Permissions -->
                        <div class="space-y-3">
                            <h4 class="text-base font-medium text-black">Permissions</h4>
                            
                            <div class="space-y-2">
                                <label class="flex items-center">
                                    <input type="checkbox" 
                                           name="is_active" 
                                           value="1" 
                                           {{ old('is_active', $paymentMethod->is_active) ? 'checked' : '' }}
                                           class="text-black focus:ring-black">
                                    <span class="ml-2 text-sm text-black">Active (available for customers)</span>
                                </label>
                                
                                <label class="flex items-center">
                                    <input type="checkbox" 
                                           name="allow_deposit" 
                                           value="1" 
                                           {{ old('allow_deposit', $paymentMethod->allow_deposit) ? 'checked' : '' }}
                                           class="text-black focus:ring-black">
                                    <span class="ml-2 text-sm text-black">Allow deposits</span>
                                </label>
                                
                                <label class="flex items-center">
                                    <input type="checkbox" 
                                           name="allow_withdraw" 
                                           value="1" 
                                           {{ old('allow_withdraw', $paymentMethod->allow_withdraw) ? 'checked' : '' }}
                                           class="text-black focus:ring-black">
                                    <span class="ml-2 text-sm text-black">Allow withdrawals</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="px-4 py-4 bg-gray-50 border-t border-gray-200 dark:border-blue-600 flex justify-end space-x-3">
                        <a href="{{ route('admin.payment_methods.index') }}" 
                           class="px-4 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-200 transition-all duration-200">
                            Cancel
                        </a>
                        <button type="submit" 
                                class="px-6 py-2 bg-black dark:bg-white text-white dark:text-blue-900 text-sm font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-blue-50 transition-all duration-200">
                            Update Payment Method
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function toggleCryptoFields() {
            const typeSelect = document.getElementById('type');
            const cryptoFields = document.getElementById('crypto-fields');
            
            if (typeSelect.value === 'cryptocurrency') {
                cryptoFields.style.display = 'block';
            } else {
                cryptoFields.style.display = 'none';
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            toggleCryptoFields();
        });
    </script>
</x-admin-layout> 
