<x-guest-layout>
    <x-slot name="title">Confirm Password</x-slot>

    <div class="bg-white rounded-lg shadow-sm border border-gray-200 dark:border-blue-600 overflow-hidden">
        <!-- Header -->
        <div class="px-8 py-8 text-center">
            <h1 class="text-3xl font-light text-black dark:text-white mb-2">Confirm Password</h1>
            <p class="text-gray-600 dark:text-blue-100">This is a secure area of the application</p>
        </div>

        <!-- Confirm Form -->
        <div class="px-8 pb-8">
            <div class="mb-6 text-sm text-gray-600 text-center">
                Please confirm your password before continuing.
            </div>

            <form method="POST" action="{{ route('password.confirm') }}" class="space-y-6">
                @csrf

                <!-- Password -->
                <div>
                    <label for="password" class="block text-sm font-medium text-black dark:text-white mb-2">Password</label>
                    <input type="password" 
                           id="password" 
                           name="password" 
                           required 
                           autocomplete="current-password" 
                           class="w-full px-4 py-3 border border-gray-300 rounded-md focus:outline-none focus:ring-1 focus:ring-black focus:border-black transition-colors duration-200 @error('password') border-red-500 @enderror">
                    @error('password')
                        <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Submit Button -->
                <div class="pt-4">
                    <button type="submit" class="w-full bg-black hover:bg-gray-800 text-white py-3 px-6 rounded-md text-base font-medium transition-all duration-200">
                        Confirm
                    </button>
                </div>
            </form>
        </div>

        <!-- Back Link -->
        <div class="px-8 py-6 bg-gray-50 border-t border-gray-200 dark:border-blue-600 text-center">
            <p class="text-sm text-gray-600 dark:text-blue-100">
                <a href="{{ route('dashboard') }}" class="text-black hover:text-gray-600 font-medium transition-colors duration-200">
                    Back to Dashboard
                </a>
            </p>
        </div>
    </div>
</x-guest-layout>
