<x-guest-layout>
    <x-slot name="title">Reset Password</x-slot>

    <div class="bg-white dark:bg-blue-700 rounded-xl shadow-sm border border-gray-100 overflow-hidden">
        <!-- Enhanced Header -->
        <div class="px-6 py-6 text-center">
            <h1 class="text-xl font-light text-black dark:text-white mb-1">Reset Password</h1>
            <p class="text-xs text-gray-500 dark:text-blue-200">Enter your email to receive a reset link</p>
        </div>

        <!-- Session Status -->
        @if (session('status'))
            <div class="bg-green-50 border-l-4 border-green-500 p-3 mb-4 mx-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i data-lucide="check-circle" class="w-4 h-4 text-green-500"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-xs text-green-700">{{ session('status') }}</p>
                    </div>
                </div>
            </div>
        @endif

        <!-- Reset Form -->
        <div class="px-6 pb-6">
            <div class="mb-4 text-xs text-gray-500 text-center">
                Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.
            </div>

            <form method="POST" action="{{ route('password.email') }}" class="space-y-4">
                @csrf

                <!-- Email Address -->
                <div>
                    <label for="email" class="block text-xs font-medium text-black dark:text-white mb-1">Email</label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           value="{{ old('email') }}" 
                           required 
                           autofocus 
                           class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 @error('email') border-red-500 @enderror">
                    @error('email')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Submit Button -->
                <div class="pt-2">
                    <button type="submit" class="w-full bg-black hover:bg-gray-800 text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                        Email Password Reset Link
                    </button>
                </div>
            </form>
        </div>

        <!-- Back to Login Link -->
        <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 text-center">
            <p class="text-xs text-gray-500 dark:text-blue-200">
                Remember your password?
                <a href="{{ route('login') }}" class="text-black hover:text-gray-600 font-medium transition-colors duration-200">
                    Sign in
                </a>
            </p>
        </div>
    </div>
</x-guest-layout>
