<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ isset($title) ? $title . ' - ' . site_name() : site_name() }}</title>

        <!-- Favicon -->
        @if(site_favicon())
            <link rel="icon" type="image/x-icon" href="{{ site_favicon() }}">
        @endif

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <script>
        // Initialize theme based on system preference
        function initTheme() {
            const savedTheme = localStorage.getItem('theme');
            const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            
            if (savedTheme) {
                // Use saved preference
                if (savedTheme === 'dark') {
                    document.documentElement.classList.add('dark');
                } else {
                    document.documentElement.classList.remove('dark');
                }
            } else {
                // Use system preference
                if (prefersDark) {
                    document.documentElement.classList.add('dark');
                } else {
                    document.documentElement.classList.remove('dark');
                }
            }
        }
        initTheme();
        
        // Listen for system theme changes
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', (e) => {
            if (!localStorage.getItem('theme')) {
                if (e.matches) {
                    document.documentElement.classList.add('dark');
                } else {
                    document.documentElement.classList.remove('dark');
                }
            }
        });
    </script>
</head>
<body class="font-sans antialiased bg-gray-50 dark:bg-blue-900 text-black dark:text-white transition-colors duration-200">
    <div class="min-h-screen flex flex-col">
        <!-- Enhanced Navigation -->
        <nav class="bg-white dark:bg-blue-800 border-b border-gray-100 dark:border-blue-700 shadow-sm transition-colors duration-200">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-14">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <a href="{{ route('home') }}" class="flex items-center group">
                            @if(site_logo())
                                <img src="{{ site_logo() }}" alt="{{ site_name() }}" class="h-6 w-auto group-hover:opacity-70 transition-opacity duration-200">
                            @else
                                <span class="text-lg font-bold text-black dark:text-white group-hover:opacity-70 transition-opacity duration-200">{{ site_name() }}</span>
                            @endif
                        </a>
                    </div>

                    <!-- Right Side Links -->
                    <div class="flex items-center space-x-4 md:space-x-6">
                        <a href="{{ route('home') }}" class="hidden md:block text-xs font-medium text-black dark:text-blue-100 hover:text-gray-600 dark:hover:text-white transition-colors duration-200">Home</a>
                        <a href="{{ route('cars.browse') }}" class="hidden md:block text-xs font-medium text-black dark:text-blue-100 hover:text-gray-600 dark:hover:text-white transition-colors duration-200">Inventory</a>
                        @if (Route::has('login'))
                            @auth
                                <a href="{{ route('dashboard') }}" class="hidden md:block text-xs font-medium text-black dark:text-blue-100 hover:text-gray-600 dark:hover:text-white transition-colors duration-200">Dashboard</a>
                            @else
                                <a href="{{ route('login') }}" class="hidden sm:block text-xs font-medium text-black dark:text-blue-100 hover:text-gray-600 dark:hover:text-white transition-colors duration-200">Sign In</a>
                                @if (Route::has('register'))
                                    <a href="{{ route('register') }}" class="hidden sm:block text-xs font-medium text-black dark:text-blue-100 hover:text-gray-600 dark:hover:text-white transition-colors duration-200">Register</a>
                                @endif
                            @endauth
                        @endif
                        
                        <!-- Theme Toggle (Visible on all screen sizes) -->
                        <button id="theme-toggle" onclick="toggleTheme()" class="p-2 rounded-lg hover:bg-gray-100 dark:hover:bg-blue-700 transition-colors duration-500" aria-label="Toggle theme">
                            <i data-lucide="sun" class="w-4 h-4 text-gray-700 dark:text-blue-100 dark:hidden"></i>
                            <i data-lucide="moon" class="w-4 h-4 text-blue-100 hidden dark:block"></i>
                        </button>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Enhanced Main Content -->
        <main class="flex-grow flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
            <div class="w-full max-w-sm">
                {{ $slot }}
            </div>
        </main>

        <!-- Enhanced Footer -->
        <footer class="bg-black dark:bg-blue-800 text-white dark:text-blue-100 py-6 transition-colors duration-200">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <div class="mb-3 md:mb-0">
                        <p class="text-xs text-gray-400 dark:text-blue-200">&copy; {{ date('Y') }} {{ site_name() }}. All rights reserved.</p>
                    </div>
                    <div class="flex space-x-6">
                        <a href="{{ route('privacy') }}" class="text-xs text-gray-400 dark:text-blue-200 hover:text-white transition-colors duration-200">Privacy Policy</a>
                        <a href="{{ route('terms') }}" class="text-xs text-gray-400 dark:text-blue-200 hover:text-white transition-colors duration-200">Terms of Service</a>
                        <a href="{{ route('contact') }}" class="text-xs text-gray-400 dark:text-blue-200 hover:text-white transition-colors duration-200">Contact</a>
                    </div>
                </div>
            </div>
        </footer>
    </div>
    
    <script>
        // Initialize Lucide icons when DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
        });
        
        function toggleTheme() {
            const html = document.documentElement;
            const isDark = html.classList.contains('dark');
            
            if (isDark) {
                html.classList.remove('dark');
                localStorage.setItem('theme', 'light');
            } else {
                html.classList.add('dark');
                localStorage.setItem('theme', 'dark');
            }
            
            // Reinitialize Lucide icons
            setTimeout(() => {
                if (typeof lucide !== 'undefined') {
                    lucide.createIcons();
                }
            }, 100);
        }
    </script>
</body>
</html>
